# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Rounds (1-3)
    if current_round == 1:
        return "C"
    elif 2 <= current_round <= 3:
        if opp_history[0] == "D":
            return "D"
        else:
            if current_round == 3 and random.random() < 0.1:
                return "D"
            else:
                return opp_history[-1]
    
    # Middle Rounds (4-7)
    elif 4 <= current_round <= 7:
        if "D" in opp_history[:3]:
            return "D"
        else:
            if "D" in opp_history[3:current_round-1]:
                return "D"
            else:
                return "C"
    
    # Final Rounds (8-10)
    else:
        coop_rate = opp_history.count("C") / len(opp_history)
        if coop_rate >= 0.7:
            return "C"
        else:
            return "D"